"""
### AegisNX System 终端
"""
############################################################################################################################################
# python库导入部分
import sys, time, os, random, logging, subprocess, utils, keyboard, threading, platform, re, getpass, hashlib, yaml, socket, psutil
from colorama import init, Fore, Style, Back
from datetime import datetime
from rich.progress import track  # 可以使用 rich 库实现酷炫进度条
from ruamel.yaml import YAML
from ruamel.yaml.comments import CommentedSeq

import AegisNX_Tool_software

############################################################################################################################################
# 函数与初始化部分
init(autoreset=True, convert=True)   # convert=True 是关键

def color_status(status):
    if status == "[INFO]":
        return Fore.CYAN + status + Style.RESET_ALL
    elif status == "[OK]":
        return Fore.GREEN + status + Style.RESET_ALL
    elif status == "[WARNING]":
        return Fore.YELLOW + status + Style.RESET_ALL
    elif status == "[CRITICAL]":
        return Fore.RED + status + Style.RESET_ALL
    return status


def print_line(status, text, delay=0.02):
    print(f"{color_status(status)} {text}")
    time.sleep(delay)


def section_pause(min_delay=0.3, max_delay=1):
    time.sleep(random.uniform(min_delay, max_delay))


# 终端部分的初始化
# 当前路径
path = "~"

# 弱密码字典，可以自行扩充
weak_passwords = {
    "123456", "12345678", "123456789", "password", "qwerty",
    "abc123", "admin", "admin123", "welcome", "1234567890",
    "test123", "admin@123", "a1b2c33", "a1b2c33.","a1b2c3"
}

work_book = """
        \t\t╔═══════════════════════════════════════════════════════════════════════╗
        \t\t║                    反间谍侦察与特别行动组 工作手册                    ║
        \t\t║───────────────────────────────────────────────────────────────────────║
        \t\t║                                                                       ║
        \t\t║  一、基本信息                                                         ║
        \t\t║    工作邮箱号码：agent01@isd.gov                                      ║
        \t\t║    工作邮箱密码：TRNDNSA@1960x                                        ║
        \t\t║                                                                       ║
        \t\t║    工作代号：由组织统一分配，内部使用，不得擅自对外公开。             ║
        \t\t║                                                                       ║
        \t\t║    特别备注：工作邮箱无法在工作单位以外登录与使用，所有通信内容均由   ║
        \t\t║              信息安全部门实时监控，请严守保密条令和单位规章制度。     ║
        \t\t║                                                                       ║
        \t\t║  二、工作职责                                                         ║
        \t\t║     1. 反间谍侦察：识别敌对势力，掌握涉密动态。                       ║
        \t\t║     2. 情报收集：获取情报，研判敌情，形成报告。                       ║
        \t\t║     3. 网络攻防：防御渗透与攻击，必要时反制。                         ║
        \t\t║     4. 执法行动：开展抓捕与排查。                                     ║
        \t\t║                                                                       ║
        \t\t║   三、工作纪律                                                        ║
        \t\t║     · 严格遵守保密制度，不得通过私人渠道传播涉密信息。                ║
        \t\t║     · 所有对外言论需符合组织要求。                                    ║
        \t\t║     · 行动任务必须听从指挥，不得私自行动。                            ║
        \t\t║     · 遇突发情况，第一时间向直属上级汇报。                            ║
        \t\t║     · 严格区分生活与工作，杜绝泄密。                                  ║
        \t\t║                                                                       ║
        \t\t║   四、日常规定                                                        ║
        \t\t║     · 上班前检查设备状态。                                            ║
        \t\t║     · 每日清理临时文件并提交日志。                                    ║
        \t\t║     · 外出任务携带证件、装备。                                        ║
        \t\t║     · 禁止擅自拍摄存储机密资料。                                      ║
        \t\t║                                                                       ║
        \t\t║   五、警示提醒                                                        ║
        \t\t║     · 违反保密纪律将依法追责。                                        ║
        \t\t║     · 工作邮箱仅限公务用途，不得夹带私事。                            ║
        \t\t║     · 所有行动与资料均有留痕，切勿侥幸。                              ║
        \t\t║                                                                       ║
        \t\t║───────────────────────────────────────────────────────────────────────║
        \t\t║                忠诚无瑕、让国安宁、甘于奉献、敢战能胜。               ║
        \t\t╚═══════════════════════════════════════════════════════════════════════╝\n"""

help_all_book = """
    完整命令         功能               简短命令
    SentinelWeb     浏览器              web\\sw
    CipherMail      工作邮箱            cmail\\cm
    DataForge       数据库              data\\df
    EchoTalk        破解                et
    SparklyAegis    社交                sparkly\\sa
    KeyBreaker      追踪                kb
    ShadowTrace     入侵                st
    Crypto          解密工具            cr
    clear           清楚屏幕            cls
    ip add          查看IP信息          \
    ifcongig        查看网卡信息        \
    cd              切换路径            \
    ls              查看路径下的内容    \
    cat             查看文件内容        \
    pwd             查看当前路径        \
"""

help_book = """
    完整命令         功能
    help            查看帮助
    help -all       查看帮助（完整）
    ip add          查看IP信息
    ifcongig        查看网卡信息
    cd              切换路径
    ls              查看路径下的内容
    cat             查看文件内容
    pwd             查看当前路径
"""

First_Login = True
USER_FILE = "users.txt"
############################################################################################################################################
# 程序主要部分

###############################################################################################
# 注册环境
utils.clear()
manager = utils.UserManager()
if manager.has_registered_users():
    username = manager.login_user()  # 只允许登录
else:
    username = manager.register_user(weak_passwords)  # 没有用户时允许注册

###############################################################################################
# 打印用户电脑计算机硬件信息
collector = utils.SystemInfoCollector()
collector.collect()
collector.display()

print("\n═══════════════════════════════════════════════════════════════════════════════════\n")

# 打印设备性能良好！
utils.typewriter(
    text=f"  设备性能：[良好] \n",
    color=Fore.WHITE, speed=0.1, await_speed=0.6, delete=False
)
# 加载动画
utils.waiting_dots(text="  正在建立连接", repeat=2)

print("\n═══════════════════════════════════════════════════════════════════════════════════\n")

# === OS Boot ===
print_line("[INFO]", "Starting AegisNX 3.1.72 Boot Sequence...")
time.sleep(0.5)
section_pause()

# === CPU ===
cpu_models = [
    "QuantumCore X-9800, 32 Threads, 5.2GHz",
    "NeuroChip Z-7, 24 Threads, 4.8GHz",
    "TitaniumCore G-12, 16 Threads, 5.0GHz",
    "PhotonCore R-11, 28 Threads, 5.1GHz",
    "OmegaCore V-14, 36 Threads, 4.9GHz"
]
cpu_choice = random.choice(cpu_models)
print_line("[OK]", f"CPU Detected: {cpu_choice}")
section_pause()

# === RAM ===
print_line("[INFO]", "Detecting RAM Modules...")
ram_modules = []
for i in range(4):
    size_gb = 16
    ram_type = "DDR7"
    model = f"HyperX-Fake{i+1}"
    speed = random.choice([3600, 3800, 4000, 4200])
    ram_modules.append(f"{size_gb}GB {ram_type} {model} {speed}MHz")
print_line("[OK]", f"RAM Detected: 64GB (4 x 16GB DDR7)")
for module in ram_modules:
    print_line("[OK]", f"    {module}", delay=0.01)
section_pause()

# === GPU ===
gpu_models = [
    "Obsidian RTX Titan, 48GB GDDR7X",
    "ShadowFire RX Xtreme, 32GB GDDR7",
    "NovaCore Vega Ultra, 64GB GDDR8",
    "QuantumFlux GT-9000, 48GB GDDR7",
    "AuroraFire Z-12, 36GB GDDR6X"
]
gpu_choice = random.choice(gpu_models)
print_line("[OK]", f"GPU Detected: {gpu_choice}")
section_pause()

# === Motherboard ===
mb_models = [
    "Cerberus Prime Z990, SN: ZX990-221112",
    "Aetherium Max Q5, SN: Q5-998877",
    "PhantomCore X7, SN: PX7-334455",
    "TitaniumEdge R2, SN: TE2-776655",
    "VortexMax Ultra, SN: VMU-443322"
]
mb_choice = random.choice(mb_models)
print_line("[OK]", f"Motherboard Detected: {mb_choice}")
section_pause()

# === Storage ===
print_line("[INFO]", "Scanning Storage Devices...")
ssd_sizes = ["2TB", "4TB", "4TB"]
ssd_models = [f"XenonSSD-{i+1} Ultra" for i in range(3)]
print_line("[OK]", f"Storage Devices: SSD Array: 10TB ({' + '.join(ssd_sizes)}) NVMe RAID-0")
for model, size in zip(ssd_models, ssd_sizes):
    print_line("[OK]", f"    {model} {size}", delay=0.01)
section_pause()

# === BIOS ===
bios_versions = [
    "Aegis BIOS v4.12.33",
    "Aether BIOS v3.99.88",
    "Phantom BIOS v5.01.07",
    "Titan BIOS v6.01.12",
    "Quantum BIOS v7.00.01"
]
bios_choice = random.choice(bios_versions)
print_line("[OK]", f"BIOS Version: {bios_choice}")
section_pause()

# === PCI Devices ===
print_line("[INFO]", "Enumerating PCI Devices...")
pci_devices = [f"PCI Device {i}: FakeDevice-{i} Gen3" for i in range(1, 12)]
for dev in pci_devices:
    status = random.choices(["[INFO]", "[OK]", "[WARNING]"], weights=[0.3,0.6,0.1])[0]
    print_line(status, dev, delay=0.01)
section_pause()

# === Network Adapters ===
print_line("[INFO]", "Checking Network Adapters...")
net_adapters = [f"Ethernet Adapter {i}: VirtuNet-{i} 10Gbps" for i in range(1,5)]
for adapter in net_adapters:
    print_line("[OK]", adapter, delay=0.01)
section_pause()

# === USB Devices ===
print_line("[INFO]", "Detecting USB Devices...")
usb_devices = [f"USB Device {i}: VirtualInput-{i}" for i in range(1,9)]
for usb in usb_devices:
    status = random.choices(["[INFO]", "[OK]", "[WARNING]"], weights=[0.3,0.6,0.1])[0]
    print_line(status, usb, delay=0.01)
section_pause()

# === Security & AI Modules ===
security_modules = [
    "AI Firewall Module v2.3",
    "Quantum Encryption Accelerator",
    "Behavioral Intrusion Detection System",
    "Neural AI Scan Engine",
    "DeepPacket Analyzer v5.1"
]
for module in security_modules:
    status = random.choices(["[OK]", "[WARNING]"], weights=[0.85,0.15])[0]
    print_line(status, f"Security Module Loaded: {module}", delay=0.02)
section_pause()

# === Services ===
print_line("[INFO]", "Starting system services...")
services = [f"Service-{i}: Running" for i in range(1,31)]
for service in services:
    status = random.choices(["[OK]", "[WARNING]", "[CRITICAL]"], weights=[0.7,0.2,0.1])[0]
    print_line(status, service, delay=0.01)
section_pause()

# === Finalizing ===
print_line("[INFO]", "Finalizing boot sequence...")
print_line("[OK]", "AegisNX System Boot Completed Successfully!")
print_line("[INFO]", "Welcome, Operator. All systems nominal.")

# Extra delay for visual effect
# 打印工作手册
OS_LOGO_lines = [
    "\n═══════════════════════════════════════════════════════════════════════════════════\n",
    "     █████╗ ███████╗ ██████╗ ██╗███████╗███╗   ██╗██╗  ██╗     ██████╗ ███████╗ ",
    "    ██╔══██╗██╔════╝██╔════╝ ██║██╔════╝████╗  ██║╚██╗██╔╝    ██╔═══██╗██╔════╝ ",
    "    ███████║█████╗  ██║  ███╗██║███████╗██╔██╗ ██║ ╚███╔╝     ██║   ██║███████╗ ",
    "    ██╔══██║██╔══╝  ██║   ██║██║╚════██║██║╚██╗██║ ██╔██╗     ██║   ██║╚════██║ ",
    "    ██║  ██║███████╗╚██████╔╝██║███████║██║ ╚████║██╔╝ ██╗    ╚██████╔╝███████║ ",
    "    ╚═╝  ╚═╝╚══════╝ ╚═════╝ ╚═╝╚══════╝╚═╝  ╚═══╝╚═╝  ╚═╝     ╚═════╝ ╚══════╝ ",
    "\n═══════════════════════════════════════════════════════════════════════════════════\n",
]

for OS_LOGO_line in OS_LOGO_lines:
    print(f"{Fore.LIGHTGREEN_EX}{OS_LOGO_line}{Style.RESET_ALL}")
    time.sleep(0.18)  # 控制每行之间的延迟

time.sleep(1)
utils.clear()


###############################################################################################
# 终端提示符
print(help_book)

while 1:
    user_command = input(f"{username}@AegisNX:[{path}]# ").strip().lower()

    ###############################################################################################
    # 工具判断
    if user_command in ["sentinelweb","web","sw"]: # 浏览器
        if AegisNX_Tool_software.AegisNX_SentinelWeb() == "exit":
            print("已退出 SentinelWeb")
            time.sleep(0.5)
            utils.clear()

    elif user_command in ["ciphermail","cmail","cm"]: # 邮箱
        if AegisNX_Tool_software.AegisNX_CipherMail() == "exit":
            print("已退出 CipherMail")
            time.sleep(0.5)
            utils.clear()
            
    elif user_command in ["dataforge","data","df"]: # 数据库
        if AegisNX_Tool_software.AegisNX_DataForge() == "exit":
            print("已退出 DataForge")
            time.sleep(0.5)
            utils.clear()

    elif user_command in ["echotalk","et"] : # 破解
        if AegisNX_Tool_software.AegisNX_EchoTalk() == "exit":
            print("已退出 EchoTalk")
            time.sleep(0.5)
            utils.clear()

    elif user_command in ["sparklyaegis","sparkly","sa"]: # 社交软件
        if AegisNX_Tool_software.AegisNX_SparklyAegis() == "exit":
            print("已退出 Sparkly Aegis")
            time.sleep(0.5)
            utils.clear()

    elif user_command in ["keybreake","kb"]: # 追踪
        if AegisNX_Tool_software.AegisNX_KeyBreaker() == "exit":
            print("已退出 KeyBreaker")
            time.sleep(0.5)
            utils.clear()

    elif user_command in ["shadowtrace","st"]: # 入侵
        if AegisNX_Tool_software.AegisNX_ShadowTrace() == "exit":
            print("已退出 ShadowTrace")
            time.sleep(0.5)
            utils.clear()

    elif user_command in ["crypto","cr"]:
        if AegisNX_Tool_software.crypto_tool() == "exit":
            print("已退出 crypto")
            time.sleep(0.5)
            utils.clear()
    ###############################################################################################
    # 其他命令判断
    elif user_command == "ip add": # 查看IP信息
        AegisNX_Tool_software.AegisNX_ip_add()

    elif user_command == "ifconfig": # 查看网卡信息
        AegisNX_Tool_software.AegisNX_ifconfig()

    elif user_command in ["help","help -all"]: # 查看帮助
        if user_command == "help -all":
            print(help_all_book)
        else:
            print(help_book)

    elif user_command[0:2] == "cd": # 切换路径
        pass

    elif user_command[0:2] == "ls": # 查看当前或其他路径下的内容
        print("workbook.txt\n")
        

    elif user_command[0:3] == "cat": # 查看文件内容
        if user_command == "cat workbook.txt":
            print(work_book)

    elif user_command[0:3] == "pwd": # 查看当前路径
        pass

    elif user_command in ["clear","cls"]:
        utils.clear()
    ###############################################################################################
    # 没有命令
    else: 
        print("command not found\n")

# utils.terminal_prompt(username)