"""
#### AegisNX 工具软件函数文件
"""
############################################################################################################################################
# python库导入部分
import sys, time, os, random, logging, subprocess, utils, keyboard, threading, platform, re, getpass, hashlib, yaml, socket, psutil, base64
from colorama import init, Fore, Style, Back
from datetime import datetime
from rich.progress import track  # 可以使用 rich 库实现酷炫进度条
from ruamel.yaml import YAML
from ruamel.yaml.comments import CommentedSeq

############################################################################################################################################
# 浏览器 SentinelWeb

def AegisNX_SentinelWeb():
    """
    AegisNX SentinelWeb - 浏览器工具（仅终端界面）
    
    功能：
    - 搜索
    - 搜索结果
    - 查看搜索
    """
    # 读取数据库
    with open("./YAML_Data_storage_files/search_data.yaml", "r", encoding="utf-8") as f:
        SEARCH_DB = yaml.safe_load(f)

    with open("./YAML_Data_storage_files/pages.yaml", "r", encoding="utf-8") as f:
        PAGES = yaml.safe_load(f)
    
    # 浏览器主要代码
    while True:
        utils.clear()
        print("=== Sentinel 浏览器 ===")
        cmd = input("输入命令：\n  S [搜索词] - 搜索 |  Q - 退出浏览器\n:: ").strip().lower()

        if cmd == "q":
            return "exit"
 
        elif cmd.startswith("s "):  # 搜索
            query = cmd[2:]
            results = SEARCH_DB.get(query, {}).get("results", [])

            while True:
                utils.clear()
                print(f"=== 搜索结果：{query} ===\n")
                if not results:
                    print("没有找到相关结果。")
                else:
                    for r in results:
                        print(f"[{r['id']}] {r['title']}\n    {r['summary']}\n")

                sub_cmd = input("\n输入命令：\n  L [编号] - 打开搜索结果 |  S [搜索词] - 搜索新内容 |  Q - 退出浏览器\n:: ").strip().lower()

                if sub_cmd == "q":
                    return "exit"

                elif sub_cmd.startswith("s "):  # 新搜索
                    query = sub_cmd[2:]
                    results = SEARCH_DB.get(query, {}).get("results", [])

                elif sub_cmd.startswith("l "):  # 打开网页
                    try:
                        page_id = int(sub_cmd[2:])
                        page = next((r for r in results if r['id'] == page_id), None)
                        if page:
                            while True:
                                utils.clear()
                                print(f"=== {page['title']} ===\n")
                                print(PAGES.get(page['url'], "⚠ 内容加载失败"))

                                page_cmd = input("\n输入命令：\n  X - 返回搜索结果 |  Q - 退出浏览器\n:: ").strip().lower()
                                if page_cmd == "x":
                                    break
                                elif page_cmd == "q":
                                    return "exit"
                    except ValueError:
                        pass


############################################################################################################################################
# 邮箱 CipherMail

def AegisNX_CipherMail():
    """
    AegisNX CipherMail - 工作邮箱工具（仅终端界面）
    
    功能：
    - 用户登录（无注册）
    - 查看邮件列表
    - 查看单封邮件内容
    - 下载附件（写入文件）
    - 支持退出登录（T 键）
    """

    download_dir = os.path.join(os.getcwd(), "attachments")  # 指定附件下载目录
    os.makedirs(download_dir, exist_ok=True)  # 确保目录存在

    # 读取邮件数据
    with open("./YAML_Data_storage_files/mails.yaml", "r", encoding="utf-8") as f:
        MAILS = yaml.safe_load(f)

    # 模拟一个简单的账号系统
    VALID_USERS = {
        "agent01@isd.gov": "TRNDNSA@1960x",
        "admin": "password",
        "shadowcat@hup.com": "Scat900501"
    }

    while True:  # 整个邮箱系统的主循环
        # 登录阶段
        while True:
            utils.clear()
            print("=== CipherMail 登录界面 ===")
            cmd = input("输入命令：\n  A - 登录 |  Q - 退出软件\n:: ").strip().lower()

            if cmd == "q":
                return "exit"

            elif cmd == "a":
                username = input("用户名：").strip()
                password = input("密码：").strip()
                if VALID_USERS.get(username) == password:
                    print(f"\n✅ 登录成功！欢迎，{username}")
                    time.sleep(1)
                    break  # 进入邮箱
                else:
                    print("\n❌ 登录失败，用户名或密码错误。")
                    time.sleep(1)

        # 邮件列表阶段
        while True:
            utils.clear()
            print("────────────────────────────────────────────────────────────")
            print("=== 邮箱收件箱 ===\n")
            user_mails = [m for m in MAILS if m.get("to") == username]

            if not user_mails:
                print("📭 没有邮件。")
            else:
                for m in user_mails:
                    print(f"[{m['uid']}] {m['title']} - 来自 {m['from']}")

            print("────────────────────────────────────────────────────────────")

            cmd = input("\n输入命令：\n  L [编号] - 查看邮件 |  T - 退出登录 |  Q - 退出软件\n:: ").strip().lower()

            if cmd == "q":
                return "exit"

            elif cmd == "t":
                break  # 返回登录页

            elif cmd.startswith("l "):  # 查看邮件
                try:
                    mail_id = int(cmd[2:])
                    mail = next((m for m in user_mails if m['uid'] == mail_id), None)
                    if mail:
                        while True:
                            utils.clear()
                            print("────────────────────────────────────────────────────────────")
                            print(f"=== {mail['title']} ===")
                            print(f"来自: {mail['from']}")
                            print(f"时间: {mail['date']}\n")
                            print(mail['content'])
                            print("────────────────────────────────────────────────────────────")

                            sub_cmd = input("\n输入命令：\n  D - 下载附件 |  X - 返回邮件列表 |  T - 退出登录 |  Q - 退出软件\n:: ").strip().lower()
                            if sub_cmd == "x":
                                break
                            elif sub_cmd == "q":
                                return "exit"
                            elif sub_cmd == "t":
                                mail = None
                                break  # 退出到登录页

                            elif sub_cmd == "d":
                                attachment = None
                                if "attachment" in mail and mail["attachment"]:
                                    attachment = mail["attachment"]
                                elif "attachment_teshu" in mail and mail["attachment_teshu"]:
                                    attachment = mail["attachment_teshu"]

                                if attachment:
                                    filename = attachment["filename"]
                                    content = attachment["content"]

                                    # 初始路径
                                    file_path = os.path.join(download_dir, filename)

                                    # 如果文件已存在，加 (1)、(2)...
                                    base, ext = os.path.splitext(filename)
                                    counter = 1
                                    while os.path.exists(file_path):
                                        new_filename = f"{base}({counter}){ext}"
                                        file_path = os.path.join(download_dir, new_filename)
                                        counter += 1

                                    # 写入文件
                                    with open(file_path, "w", encoding="utf-8") as f:
                                        f.write(content)

                                    print(f"📥 附件已下载：{file_path}")
                                    time.sleep(3)
                                else:
                                    print("⚠️ 邮件中没有可下载的附件。")
                                time.sleep(1)

                        if sub_cmd == "t":  # 如果在查看邮件里按 T
                            break  # 跳出邮件列表，回到登录页
                except ValueError:
                    pass


############################################################################################################################################
# 数据库 DataForge

def AegisNX_DataForge():
    """AegisNX DataForge - 全国公民信息数据库"""

    if not os.path.exists("./YAML_Data_storage_files/citizens.yaml"):
        print("⚠ 公民数据库未找到！")
        return "exit"

    with open("./YAML_Data_storage_files/citizens.yaml", "r", encoding="utf-8") as f:
        citizens = yaml.safe_load(f)

    print("\n=== DataForge 公民信息查询 ===")
    utils.clear_last_lines(3)
    # 进入循环查询模式
    while True:
        # 输入必须包含姓名 + 关键字段二
        name = input("\n姓名（必填）: ").strip()
        if not name:
            print("⚠ 姓名不能为空！")
            time.sleep(0.5)
            utils.clear_last_lines(3)
            continue

        second = input("电话 / 生日(YYYY-MM-DD) / 住址（必填三选一）: ").strip()
        if not second:
            print("⚠ 必须填写一个电话/生日/住址！")
            time.sleep(0.5)
            utils.clear_last_lines(3)
            continue

        field_type = utils.identify_field(second)

        if field_type == "[Error] 无法识别":
            print(field_type)
            time.sleep(0.5)
            utils.clear_last_lines(3)
            continue

        # 模拟进度条
        print("\n查询中", end="")
        for _ in range(10):
            print(".", end="", flush=True)
            time.sleep(0.1)
        print("\n")

        # 查询
        results = []
        for c in citizens:
            if c.get("name") == name and c.get(field_type) == second:
                results.append(c)

        if not results:
            print("⚠ 查无此人！")
        else:
            # 字段映射表：原始字段 -> 中文显示名
            FIELD_MAP = {
                "name": "姓名",
                "sex": "性别",
                "nation": "民族",
                "native_place": "籍贯",
                "profession": "职业",
                "birthday": "出生日期",
                "age": "年龄",
                "phone": "电话号码",
                "email": "电子邮箱",
                "id_card": "身份证号",
                "address": "居住地址",
            }

            # 打印结果时使用映射表
            for c in results:
                print("────────────────────────────────────────")
                for key, label in FIELD_MAP.items():
                    if key in c:
                        print(f"{label}: {c[key]}")
                print("────────────────────────────────────────")


        # 继续 / 退出
        sub_cmd = input("\n输入命令：\n X 继续查询 |  Q 退出\n:: ").strip().lower()
        if sub_cmd == "x":
            # ⚠ 直接继续查询，不回到首页
            utils.clear_last_lines(21)
            continue
        elif sub_cmd == "q":
            return "exit"


############################################################################################################################################
# 破解 EchoTalk

def AegisNX_EchoTalk():
    """AegisNX EchoTalk - 社工密码破解系统（终端界面）"""

    # 读取数据库
    if not os.path.exists("./YAML_Data_storage_files/citizens.yaml"):
        print("⚠ 公民数据库文件不存在！")
        return "exit"

    with open("./YAML_Data_storage_files/citizens.yaml", "r", encoding="utf-8") as f:
        CITIZENS = yaml.safe_load(f) or []

    os.system("cls" if os.name == "nt" else "clear")
    print("=== EchoTalk 密码破解系统 ===")

    while True:  # 主循环，不再返回首页菜单
        # 输入信息
        print("\n请输入公民信息进行匹配（缺一不可）：")
        name = input("姓名: ").strip()
        id_card = input("身份证: ").strip()
        nickname = input("常用昵称: ").strip()
        phone = input("电话: ").strip()
        address = input("住址: ").strip()

        # 判断邮箱字段是否存在
        emails_exist = any("email" in c and c["email"] for c in CITIZENS)
        if emails_exist:
            email = input("电子邮箱: ").strip()
        else:
            email = None

        # 匹配数据库
        matched = None
        for c in CITIZENS:
            if (
                c.get("name") == name and
                c.get("id_card") == id_card and
                c.get("nickname") == nickname and
                c.get("phone") == phone and
                c.get("address") == address and
                c.get("password") is not None
            ):
                # 邮箱字段存在时才检查邮箱
                if "email" in c and c["email"]:
                    if email and c["email"] == email:
                        matched = c
                        break
                else:
                    # 数据库没有邮箱字段，忽略用户输入
                    matched = c
                    break

        # 进度条
        print("\n🔍 破解密码中，请稍候...")
        for _ in track(range(100), description="正在尝试破解"):
            time.sleep(0.03)

        # 输出结果
        if matched:
            print("\n✅ 破解完成！\n")
            print(f"常用密码: {matched.get('password')}")
        else:
            print("\n⚠ 未找到匹配记录或信息有误！\n")

        # 继续查询或退出
        while True:
            sub_cmd = input("\n输入命令：\n X 继续查询 |  Q 退出\n:: ").strip().lower()
            if sub_cmd == "x":
                os.system("cls" if os.name == "nt" else "clear")
                break  # 直接重新进入查询输入
            elif sub_cmd == "q":
                return "exit"


############################################################################################################################################
# 社交软件 Sparkly Aegis

def AegisNX_SparklyAegis():
    """
    SparklyAegis 社交软件模拟（只读版）
    - 登录账户
    - 查看联系人列表
    - 查看与联系人的聊天记录（不可发送消息）
    """

    # 工具函数
    def load_yaml(path):
        if not os.path.exists(path):
            return {}
        with open(path, "r", encoding="utf-8") as f:
            return yaml.safe_load(f) or {}

    while True:  # 总循环
        citizens = load_yaml("./YAML_Data_storage_files/citizens.yaml")
        chats = load_yaml("./YAML_Data_storage_files/chats.yaml")

        print(Fore.CYAN + "=== SparklyAegis 安全通信 ===" + Style.RESET_ALL)
        user = None
        while not user:
            sparkly_id = input("Sparkly ID: ").strip()
            password = input("密码: ").strip()

            for c in citizens:
                if c.get("sparkly_id") == sparkly_id and c.get("password") == password:
                    user = c
                    break

            if not user:
                print(Fore.RED + "❌ 登录失败，请检查账号或密码")

        print(Fore.GREEN + f"✅ 登录成功，欢迎 {user['nickname']} ({user['sparkly_id']})")

        # 联系人列表
        while True:
            print("\n=== 联系人列表 ===")
            contacts = [c for c in citizens if c["sparkly_id"] != user["sparkly_id"]]
            for idx, contact in enumerate(contacts, start=1):
                print(f"{idx}. {contact['nickname']} ({contact['sparkly_id']})")

            cmd = input("\n输入命令：\n  L [编号] - 查看联系人聊天记录 |  T - 退出账户 |  Q - 退出系统\n:: ").strip().lower()

            if cmd == "t":
                print(Fore.YELLOW + "已退出账户")
                break
            elif cmd == "q":
                return "exit"
            elif cmd.startswith("l "):
                idx = int(cmd.split()[1]) - 1
                if 0 <= idx < len(contacts):
                    contact = contacts[idx]
                    chat_key = f"{user['sparkly_id']}|{contact['sparkly_id']}"
                    history = chats.get(chat_key, [])

                    print(f"\n=== 与 {contact['nickname']} ({contact['sparkly_id']}) 的聊天 ===")
                    if not history:
                        print("(暂无聊天记录)")
                    else:
                        for msg in history:
                            sender = msg["sender"]  # 直接用 chats.yaml 的 sender
                            message = msg["message"]

                            # 上色规则
                            if sender == "shadowcat":
                                color = Fore.WHITE
                            elif sender == "cat":
                                color = Fore.MAGENTA
                            else:
                                color = Fore.CYAN

                            print(f"{color}{sender}{Style.RESET_ALL}: {message}")

                    # 聊天控制
                    while True:
                        text = input("\n输入命令：\n  X 返回联系人列表 |  T 退出账户 |  Q 退出\n:: ").strip().lower()
                        if text == "x":
                            break
                        elif text == "t":
                            break
                        elif text == "q":
                            return "exit"

                    if text == "t":
                        break


############################################################################################################################################
# 追踪 KeyBreaker

def AegisNX_KeyBreaker():
    """
    AegisNX KeyBreaker 终端追踪系统
    - 输入终端ID追踪目标位置
    - 多个地址则模拟目标移动
    - 无地址则目标关机
    - 支持继续查询或退出
    """

    # 工具函数
    def load_yaml(path):
        if not os.path.exists(path):
            return []
        with open(path, "r", encoding="utf-8") as f:
            return yaml.safe_load(f) or []
        

    while True:  # ⭐ 总循环
        utils.clear()
        print("=== AegisNX KeyBreaker 终端追踪系统 ===")
        print("输入命令：\n  S [终端ID] - 查询目标定位  Q - 退出系统")

        cmd = input(":: ").strip().lower()

        if cmd == "q":
            return "exit"

        elif cmd.startswith("s "):
            eid = cmd.split()[1]
            citizens = load_yaml("./YAML_Data_storage_files/citizens.yaml")

            # 查找用户
            target = next((c for c in citizens if c.get("eid") == eid), None)

            if not target:
                print("❌ 未找到该终端设备 ID")
                time.sleep(1.5)
                continue

            print("─" * 70)
            for _ in track(range(20), description="搜寻设备中..."):
                time.sleep(0.05)
            print(f"✅ 已锁定目标 {target['name']} ({target['eid']})\n")

            print("正在建立追踪链路...")
            for _ in track(range(20), description="定位中..."):
                time.sleep(0.05)

            locations = target.get("location_history", [])

            print("\n📍 定位结果：")
            if not locations:
                print("终端状态：关机或无位置信息")
            else:
                for idx, loc in enumerate(locations, start=1):
                    print(f"  {idx}. {loc}")
                    utils.waiting_dots(text="持续定位中", interval=0.5, repeat=3)
                    utils.clear_last_lines(1)
                print(f"\n\n⭐ 最终落点：{locations[-1]}")

            print("─" * 70)

            # 二级循环：追踪完成后的操作
            while True:
                text = input("\n输入命令：\n  X 继续查询 |  Q 退出系统\n:: ").strip().lower()
                if text == "x":
                    break  # ⭐ 跳回最外层循环，清屏再查
                elif text == "q":
                    return "exit"
                else:
                    print("❌ 无效命令，请输入 X 或 Q")

        else:
            print("❌ 无效命令")
            time.sleep(1)


############################################################################################################################################
# 入侵 ShadowTrace

def AegisNX_ShadowTrace():
    """AegisNX ShadowTrace 入侵模拟（必须根据兴趣方向选择才能上钩）"""

    def load_yaml(path):
        if not os.path.exists(path):
            return {}
        with open(path, "r", encoding="utf-8") as f:
            data = yaml.safe_load(f)
            return data if data is not None else {}


    def waiting(msg, sec=3):
        """省略号等待"""
        for i in range(sec):
            print(msg + "." * ((i % 3) + 1), end="\r")
            time.sleep(1)
        print(" " * 50, end="\r")

    def open_image(path):
        """跨平台打开图片"""
        if os.path.exists(path):
            if os.name == "nt":  # Windows
                os.startfile(path)
            elif os.uname().sysname == "Darwin":  # macOS
                os.system(f"open '{path}'")
            else:  # Linux
                os.system(f"xdg-open '{path}'")

    citizens = load_yaml("./YAML_Data_storage_files/citizens.yaml")
    device_data = load_yaml("./YAML_Data_storage_files/device_data.yaml")

    phishing_templates = {
        "金融投资": "【HVE公司】尊敬的用户：您被我司幸运选中,请点击链接领取奖品吧",
        "社交娱乐": "【社交活动】好友推荐你参加精彩活动，点击领取专属福利",
        "学习课程": "【学习平台】你已被选中获得免费课程名额，快来领取",
        "游戏奖励": "【游戏中心】恭喜你获得限量虚拟奖励，点击领取",
    }

    while True:  # 外层循环：选择命令 A / Q
        utils.clear()
        print("=== AegisNX ShadowTrace 入侵模拟系统 ===")
        print("仅限内部办案专用，严禁用于恶意攻击行为。\n")
        choice = input("\n输入命令：\n  A - 远程入侵 |  Q - 退出\n:: ").strip().lower()
        if choice == "q":
            break
        if choice != "a":
            print("❌ 无效选择")
            time.sleep(1)
            continue

        # 远程入侵循环
        while True:
            utils.clear()
            print("=== AegisNX ShadowTrace 入侵模拟系统 ===")
            print("仅限内部办案专用，严禁用于恶意攻击行为。\n")
            phone = input("输入目标手机号：").strip()
            target = next((c for c in citizens if c.get("phone") == phone), None)
            if not target:
                print("❌ 未找到目标用户")
                time.sleep(1)
                continue

            user_interests = target.get("user_interests", [])
            if not user_interests:
                print("❌ 该目标没有兴趣方向设置，无法钓鱼")
                time.sleep(1)
                continue

            print(f"🎯 已锁定目标：{target['name']} ({phone})\n")

            # 选择兴趣方向
            while True:
                print("选择目标兴趣方向（必须选择目标感兴趣的方向才能上钩）：")
                for i, d in enumerate(phishing_templates.keys(), start=1):
                    print(f"{i}. {d}")

                idx = input("选择方向编号：").strip()
                if not idx.isdigit() or not (1 <= int(idx) <= len(phishing_templates)):
                    print("❌ 无效编号，请重新选择")
                    time.sleep(1)
                    utils.clear()
                    continue

                chosen_direction = list(phishing_templates.keys())[int(idx)-1]

                waiting("正在生成钓鱼链接", 2)
                link_id = random.randint(1000, 9999)
                phishing_link = f"{phishing_templates[chosen_direction]} https://aegis.fake.link/{link_id}"
                print(f"钓鱼链接：\n{phishing_link}\n")
                input("按回车键模拟“发送链接” → 等待目标点击...")
                waiting("目标上钩中", 3)

                if chosen_direction not in user_interests:
                    print("❌ 目标未对该方向感兴趣，请重新选择!")
                    time.sleep(1.5)
                    utils.clear()
                    continue
                else:
                    print(f"✅ 目标已上钩，正在建立远程会话...\n")
                    time.sleep(1)
                    break  # 成功上钩，进入设备浏览

            # 设备应用浏览器
            while True:
                utils.clear()
                print("=== 目标设备应用 ===")
                print("1. 相册\n2. 联系人\n3. 短信\n4. 便签\n5. 日历")
                user_input = input("\n输入命令:\n L [序号] - 查看应用 | X - 返回远程入侵 | Q - 退出工具\n:: ").strip().lower()

                if user_input == "q":
                    utils.clear()
                    return
                elif user_input == "x":
                    break  # 返回远程入侵循环

                if user_input.startswith("l "):
                    parts = user_input.split()
                    if len(parts) != 2 or not parts[1].isdigit():
                        print("❌ 命令格式错误，请输入 L [序号]")
                        time.sleep(1)
                        continue

                    app_idx = int(parts[1])
                    apps_map = {"1":"album","2":"contacts","3":"sms","4":"notes","5":"calendar"}
                    app_name = apps_map.get(str(app_idx), None)
                    if not app_name:
                        print("❌ 无效序号，请重新输入")
                        time.sleep(1)
                        continue

                    if target.get("encrypted_apps", {}).get(app_name, False):
                        pwd = input(f"{app_name} 已加密，请输入密码解锁：").strip()
                        if pwd != target.get("decrypt_password"):
                            print("❌ 密码错误")
                            time.sleep(1)
                            continue
                    
                    current_dir = os.getcwd()
                    data = device_data.get(phone, {}) or device_data.get(int(phone), {})
                    data = data.get(app_name, None)
                    utils.clear()
                    print(f"📂 {app_name}内容：\n")
                    if not data:
                        print("（无内容）")
                    else:
                        if app_name == "album":
                            for img in data:
                                print(f"打开图片：{current_dir + img}")
                                open_image(current_dir + img)
                        else:
                            if app_name == "contacts":
                                for item in data:
                                    print(f"名字：{item.get('name','')}  手机号：{item.get('phone','')}")
                            elif app_name == "sms":
                                for item in data:
                                    print(f"发件人：{item.get('from','')}  内容：{item.get('message','')}")
                            elif app_name == "calendar":
                                for item in data:
                                    print(f"日程：\n\t时间: {item.get('date','')} 内容: {item.get('event','')} 地点: {item.get('location','')} ")
                            elif app_name == "notes":
                                for item in data:
                                    print(f"便签：{item}")
                            else:
                                for item in data:
                                    print(item)

                    input("\n按回车返回设备应用菜单...")


############################################################################################################################################
# 其他命令

def AegisNX_ip_add():
    """
    ip add 命令 显示本机网卡和 IP 信息。
    """
    print("=== ip add ===")
    interfaces = psutil.net_if_addrs()
    for idx, (iface, addrs) in enumerate(interfaces.items(), start=1):
        print(f"{idx}: {iface}: <BROADCAST,MULTICAST,UP,LOWER_UP>")
        for addr in addrs:
            if addr.family == socket.AF_INET:  # IPv4
                print(f"    inet {addr.address}/{addr.netmask} brd {addr.broadcast} scope global {iface}")
            elif addr.family == socket.AF_INET6:  # IPv6
                print(f"    inet6 {addr.address} scope link")
            elif addr.family == psutil.AF_LINK:  # MAC 地址
                print(f"    link/ether {addr.address} brd ff:ff:ff:ff:ff:ff")
        print()


def AegisNX_ifconfig():
    """
    ifconfig 命令 显示网卡、MAC、IP 等信息
    """
    print("=== ifconfig ===")
    interfaces = psutil.net_if_addrs()
    stats = psutil.net_if_stats()

    for iface, addrs in interfaces.items():
        is_up = "UP" if stats[iface].isup else "DOWN"
        mtu = stats[iface].mtu if stats[iface] else 1500
        print(f"{iface}: flags=4163<{is_up},BROADCAST,RUNNING,MULTICAST>  mtu {mtu}")

        for addr in addrs:
            if addr.family == socket.AF_INET:  # IPv4
                print(f"    inet {addr.address}  netmask {addr.netmask}  broadcast {addr.broadcast}")
            elif addr.family == socket.AF_INET6:  # IPv6
                print(f"    inet6 {addr.address}  prefixlen 64  scopeid 0x20<link>")
            elif addr.family == psutil.AF_LINK:  # MAC 地址
                print(f"    ether {addr.address}  txqueuelen 1000  (Ethernet)")

        print(f"    RX packets 0  bytes 0 (0.0 B)")
        print(f"    TX packets 0  bytes 0 (0.0 B)\n")


def crypto_tool():
    """统一的解密交互工具（Base64 & 位移法）"""

    ATTACHMENT_PATH = "./attachments/"  # 固定路径

    def decode_base64(content: bytes) -> str:
        try:
            text = content.decode(errors="ignore")
            match = re.search(
                r"\s*-----BEGIN ENCRYPTED INTEL-----\s*(.*?)\s*-----END ENCRYPTED INTEL-----\s*",
                text,
                re.S,
            )
            if not match:
                raise ValueError("不是有效的 Base64 封装格式")
            b64_data = match.group(1).strip().replace("\n", "")
            return base64.b64decode(b64_data).decode("utf-8", errors="ignore")
        except Exception:
            raise ValueError("Base64 解密失败")


    def decode_shift(content: bytes) -> str:
        try:
            flag = bytearray(content)
            for i in range(0, len(flag), 2):
                flag[i] = (flag[i] - 0x03) % 256
            for i in range(1, len(flag), 2):
                flag[i] = (flag[i] - 0x05) % 256
            return flag.decode("utf-8", errors="ignore")
        except Exception:
            raise ValueError("位移解密失败")

    # 显示目录文件
    print(f"📂 当前目录 ({ATTACHMENT_PATH}) 文件列表：")
    files = os.listdir(ATTACHMENT_PATH)
    if files:
        for f in files:
            print(" -", f)
    else:
        print("（目录为空）")

    while True:
        print("\n=== 解密工具 ===")
        choice = input("1. Base64 解密 |  2. 位移解密 |  Q. 退出\n请选择操作：").strip().lower()

        if choice == "1":
            filename = input("请输入要解密的文件名：").strip()
            filepath = os.path.join(ATTACHMENT_PATH, filename)
            if not os.path.exists(filepath):
                print("❌ 文件不存在！")
                time.sleep(1)
                utils.clear()
                continue
            with open(filepath, "rb") as f:
                content = f.read()
            try:
                result = decode_base64(content)
                print("\n────────────────────────────────")
                print("✅ 解密成功：")
                print(result)
                print("────────────────────────────────\n")
                time.sleep(1)
            except ValueError as e:
                print(f"❌ {e}，请尝试别的解密方式！")
                time.sleep(1)
                utils.clear()

        elif choice == "2":
            filename = input("请输入要解密的文件名：").strip()
            filepath = os.path.join(ATTACHMENT_PATH, filename)
            if not os.path.exists(filepath):
                print("❌ 文件不存在！")
                time.sleep(1)
                utils.clear()
                continue
            with open(filepath, "rb") as f:
                content = f.read()
            try:
                result = decode_shift(content)
                print("\n────────────────────────────────")
                print("✅ 解密成功：")
                print(result)
                print("────────────────────────────────\n")
            except ValueError as e:
                print(f"❌ {e}，请尝试别的解密方式！")
                time.sleep(1)
                utils.clear()

        elif choice == "q":
            print("🔚 退出工具")
            time.sleep(1)
            return "exit"
        else:
            print("⚠️ 无效选择，请重试！")
            time.sleep(1)
            utils.clear()