# Cyber-Offensive - 网络安全教育游戏

## 项目概述
Cyber-Offensive 是一款基于 Python 开发的交互式网络安全教育游戏，旨在通过模拟国家安全人员的工作场景，向用户传授网络安全知识、数据收集和分析技能。游戏采用命令行界面，以章节化的剧情设计引导玩家完成各种安全任务。

## 技术栈
- **开发语言**：Python 3.x
- **数据存储**：YAML 文件格式
- **主要依赖**：
  - `pyyaml`：用于 YAML 文件的解析和生成
  - 标准库：sys, time, os, re, random 等

## 项目结构

```
Cyber-Offensive v0.0.1-beta/
├── AegisNX_System.py                    # AegisNX 模拟系统实现
├── AegisNX_Tool_software.py             # AegisNX 模拟系统工具软件实现
├── chapter1_prologue.py                 # 第一章：新手试炼
├── chapter2_first_trial.py              # 第二章：小试牛刀（待实现）
├── User_Privacy_Agreement_Terms_of_Use_and_Notices.py  # 用户隐私协议、使用条款和通知
├── main.py                              # 游戏主入口
├── utils.py                             # 工具函数集合
├── requirements.txt                     # 项目依赖
├── users.txt                            # 用户数据存储（首次游玩后创建）
├── YAML_Data_storage_files/             # YAML 数据存储文件夹
│   ├── chats.yaml                       # 聊天记录数据
│   ├── citizens.yaml                    # 公民信息数据库
│   ├── device_data.yaml                 # 设备数据信息
│   ├── keybreaker_logs.yaml             # 密钥破解日志
│   ├── mails.yaml                       # 邮件列表
│   ├── pages.yaml                       # 网页内容数据
│   └── search_data.yaml                 # 搜索结果数据
├── attachments/                         # 游戏中的附件文件
│   └── encrypted_hint.txt               # 加密提示文件
├── image/                               # 图片资源目录
│   ├── A1/                              # 图片资源子目录A1
│   └── A2/                              # 图片资源子目录A2
├── logs/                                # 日志文件目录
│   └── *.log                            # 按时间戳生成的日志文件
└── saves/                               # 游戏存档目录
    └── *.json                           # JSON格式的游戏存档文件
```

### 核心文件说明

- **AegisNX_System.py**：游戏中模拟的AegisNX安全系统核心实现，提供游戏内的安全工具和功能接口
- **AegisNX_Tool_software.py**：AegisNX系统的工具软件具体实现，包含各种安全工具的详细功能
- **chapter1_prologue.py**：第一章"新手试炼"的完整游戏剧情和交互逻辑，引导玩家熟悉游戏系统
- **main.py**：游戏主入口文件，负责初始化环境、显示主菜单和处理游戏流程控制
- **utils.py**：通用工具函数集合，提供打字机效果、日志管理、用户管理等基础功能
- **User_Privacy_Agreement_Terms_of_Use_and_Notices.py**：包含用户隐私协议、使用条款和游戏通知内容

### 数据存储结构

- **YAML_Data_storage_files/**：集中存放游戏中使用的所有YAML格式数据文件，便于统一管理和维护
- **attachments/**：存放游戏中需要解密或分析的附件文件
- **logs/**：自动记录游戏运行日志，按时间戳命名，便于调试和问题追踪
- **saves/**：存储玩家游戏进度的JSON格式存档文件

## 主要功能

### 1. 游戏主菜单系统
- 新游戏开始
- 存档管理（加载、保存、删除）
- 查看游戏版本信息
- 退出游戏

### 2. 交互式剧情系统
- 章节式剧情设计
- 打字机效果提升沉浸感
- 多选择分支影响游戏进程
- 任务提示和进度显示

### 3. 安全技能训练
- 电子邮件分析和附件解密
- 人物信息搜集和追踪
- 密码强度检测
- 系统信息收集

### 4. 数据存储与管理
- YAML 格式的结构化数据存储
- 用户游戏进度保存与加载
- 游戏日志记录

## 游戏玩法

### 第一章：新手试炼
玩家将扮演国家安全总局的新干警，在周安国副局长和晴川同事的指导下，完成新手训练任务。

#### 主要任务：
1. 熟悉 AegisNX 模拟系统
2. 使用 CipherMail 命令查收邮件
3. 通过 crypto 命令解密获得线索
4. 使用 sentinelweb 命令搜索目标信息
5. 收集并分析目标数据（李影/ShadowCat）

#### 主要命令：
- `CipherMail`：查看邮件系统
- `crypto`：解密文件
- `sentinelweb`：搜索目标信息

### 第二章：小试牛刀
该章节目前处于未开发阶段，尚未实现具体内容。目前规划:2026/2/4-2/15期间开发

## 数据结构

### 邮件数据 (mails.yaml)
```yaml
- id: 1
  uid: 1
  title: 欢迎加入
  from: '[地址无法解析]'
  to: agent01@isd.gov
  date: '2025-08-28'
  content: 欢迎使用CipherMail!
  attachment:  # 可选的附件
    filename: example.txt
    content: '附件内容'
```

### 公民信息 (citizens.yaml)
```yaml
- name: "李影"
  sparkly_id: "sid_shadowcat0501"
  eid: "74215560"
  decrypt_password: "1379"
  user_interests: ["社交娱乐", "游戏奖励"]
  nickname: "shadowcat"
  # ... 其他个人信息字段
```

## 系统要求
- Python 3.x
- 安装依赖：`pip install -r requirements.txt`
- 支持 Windows 命令行环境

## 运行游戏
```
python main.py
```

## 游戏特色
- 沉浸式网络安全主题剧情
- 模拟真实的信息收集和分析过程
- 交互式学习体验
- 培养网络安全意识和基本技能

## 开发计划
- 完成第二章"小试牛刀"的开发
- 增加更多安全技能训练场景
- 优化用户界面和交互体验
- 扩展数据分析和取证功能

## 注意事项
- 游戏内容为虚构，旨在教育目的
- 请勿将游戏中学习的技能用于非法用途
- 保护个人隐私，不收集真实用户数据

---

版本：v0.0.1-beta
开发团队：陆炳阳（VincentCassano）