"""
### 第一章 新手关·熟悉系统
#### Chapter1 Prologue · Getting Familiar with the System
"""
############################################################################################################################################
# python库导入部分
import sys, time, os, random, logging, subprocess, utils, keyboard, threading, platform, re, getpass, hashlib, yaml
from colorama import init, Fore, Style, Back
from datetime import datetime


############################################################################################################################################
# 初始化部分


############################################################################################################################################
# 程序主要部分
def Chapter1_Prologue_game():
    utils.clear()
    ################################################################################
    # 游戏前言
    print("════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════\n")
    utils.typewriter(
        text="\t“子弹已不再是战争的唯一语言，当屏幕点亮，网络战场的较量悄然开始。”", 
        color=Fore.CYAN, speed=0.12, await_speed=2.3, delete=True, delete_speed=0.05
    )

    utils.typewriter(
        text="\t21世纪10年代末，信息战已成为大国博弈的前线阵地；网络空间正式被确立为继陆、海、空、天之后的第五战场。\n\t随着人工智能、量子计算、信息窃取、深度伪造、社交工程等技术的极端发展，国家安全面临前所未有的挑战。", 
        color=Fore.GREEN, speed=0.12, await_speed=4.5, delete=True, delete_speed=0.04
    )

    utils.typewriter(
        text="\t2014年4月15日，\n\t中共中央总书记、国家主席习近平在中央国家安全委员会第一次全体会议上首次提出总体国家安全观重大战略思想，\n\t将网络安全问题上升到国家安全高度，深化和拓展了关于国家安全问题的理论视野和实践领域。", 
        color=Fore.YELLOW, speed=0.12, await_speed=4.5, delete=True, delete_speed=0.03
    )

    utils.typewriter(
        text="\t“这不仅是一场信息攻防的战斗，更是一场意识形态与技术的拉锯战。”", 
        color=Fore.CYAN, speed=0.12, await_speed=2.5, delete=True, delete_speed=0.05
    )

    utils.typewriter(
        text="\t本游戏剧情纯属虚构内容，如有雷同纯属巧合", 
        color=Fore.WHITE, speed=0.12, await_speed=1.2, delete=True, delete_speed=0.05
    )
    utils.clear_last_lines(1)
    print()
    time.sleep(0.8)
    

################################################################################
# 剧情对话 情景描述
    
    utils.typewriter(
        text=f"\t 同志！组织部在此通知您：\n\t     您已被编入 特别调查处。该机构隶属于 新曙光共和国国家安全总局（NDNSA），    \n\t     主要职责：在全国范围内承担反间谍侦察与情报收集任务，负责网络间谍攻击的防御 \n\t     与反制，集侦察、识别、取证、抓捕与反制于一体的综合性执法机构。             \n\t     您的档案将于3个工作日内寄送至工作单位交接，请您在此期限内前往工作单位报到！\n\n",
        color=Back.CYAN + Fore.BLACK, speed=0.08, await_speed=2.0, delete=False
    )

    # 加载动画
    utils.waiting_dots(text="\t...", repeat=3)
    

    utils.typewriter(
        text=f"\n\t【？？？】欢迎你，干警。首先，告诉我，你的姓名是什么？我们需要确认一下身份！\n",
        color=Fore.MAGENTA, speed=0.1, await_speed=0.6, delete=False
    )

    # 定义主角姓名
    sys.stdout.write(Fore.CYAN)
    Player_User_Name = input(f"\t你好！我叫（默认为许墨言）：").strip()  # 去掉前后空格
    sys.stdout.write(Style.RESET_ALL)

    if not Player_User_Name:
        Player_User_Name = "许墨言"

    # 导师 周安国 出场
    utils.typewriter(
        text=f"\n\t【周安国】{Player_User_Name}，好名字，欢迎你加入701网络防御中心。\n\t\t  我是国家安全总局局长 周安国，以后你在这里的学习和任务，将由我来指导。\n\t\t  在这里，你将学习如何守护国家信息安全，面对网络空间的挑战。\n",
        color=Fore.MAGENTA, speed=0.1, await_speed=4.0, delete=False
    )

    utils.typewriter(
        text=f"\n\t【周安国】（手机铃声响起，他看了看）我还有事，后面 晴川 同志会交代你一些事情。（转身离开）\n",
        color=Fore.MAGENTA, speed=0.1, await_speed=2.0, delete=False
    )

    # 按键提示
    input("\t[按回车继续]")
    utils.clear_last_lines(1)
    print()

    # 同事 晴川 出场
    utils.typewriter(
        text=f"\n\t【晴  川】{Player_User_Name}同志！请你把手机和其他个人电子设备上交，我们这工作期间不能使用个人电子设备。",
        color=Fore.MAGENTA, speed=0.1, await_speed=2.0, delete=False
    )

    while 1:
        sys.stdout.write(Fore.CYAN)
        User_answers = input("\n\tA.（点头，拿出手机递了过去）“好的！” \n\tB.（疑惑）“这是为什么？” \n\t请选择(A/B)：").upper()
        sys.stdout.write(Style.RESET_ALL)
        if User_answers in ["A","B"]:
            if User_answers == "B":
                utils.clear_last_lines(3)
                utils.typewriter(
                    text="\n\t（疑惑）这是为什么？\n",
                    color=Fore.CYAN, speed=0.1, await_speed=2.0, delete=False
                )
                utils.typewriter(
                    text="\n\t【晴  川】你刚来，可能还没完全意识到自己身份的分量吧？我们国安警察工作性质特殊，\n\t\t  很多事情不能随便对外说。而手机又是个随身的漏洞口，可能随时被人做手脚。\n\t\t  一旦外人盯上，植入点东西，泄露一点点信息，都会导致整个部门出问题。\n\t\t  （顿了顿）所以，不要再问为什么了，这是纪律。\n",
                    color=Fore.MAGENTA, speed=0.1, await_speed=4.0, delete=False
                )
                # 按键提示
                input("\t[按回车继续]")
                utils.clear_last_lines(1)

                utils.typewriter(
                    text="\n\t（你略显尴尬，还是把手机递了过去）\n",
                    color=Fore.CYAN, speed=0.1, await_speed=2.0, delete=False
                )
                break
            else:
                utils.clear_last_lines(3)
                utils.typewriter(
                    text="\n\t（点头，拿出手机递了过去）好的！\n",
                    color=Fore.CYAN, speed=0.1, await_speed=2.0, delete=False
                )
                break
        else:
            utils.clear_last_lines(3)

    utils.typewriter(
        text="\n\t【晴  川】（指了指桌子上的箱子）那个里面是你的工作手机、手册和其他装备，\n\t\t  记住：工作设备不能带出单位，个人设备也不能带进来。\n\t\t  每天上下班，都要按规定签收和交回——这是你的第一课。\n",
        color=Fore.MAGENTA, speed=0.1, await_speed=2.0, delete=False
    )

    # 按键提示
    input("\t[按回车继续]")
    utils.clear_last_lines(1)

    utils.typewriter(
        text="\n\t（查看箱子，一部手机，一本工作手册，两个U盘，两只黑色水笔和一本笔记本，还有一张饭卡）\n",
        color=Fore.CYAN, speed=0.1, await_speed=2.0, delete=False
    )

    # 按键提示
    input("\t[按回车继续]")
    utils.clear_last_lines(1)
    print()

    utils.typewriter(
        text="\n\t【晴  川】好了，先把东西收好，那里是你的工位。\n\t\t  （她指了指不远处的办公桌，桌上静静放着一台电脑，屏幕黑着，仿佛在等待你的到来。）  \n",
        color=Fore.MAGENTA, speed=0.1, await_speed=2.0, delete=False
    )

    # 按键提示
    input("\t[按回车继续]")
    utils.clear_last_lines(1)
    print()

    utils.typewriter(
        text="\n\t【晴  川】接下来，你要学会使用我们的系统。\n\t\t  工作手册别忘了看！\n",
        color=Fore.MAGENTA, speed=0.1, await_speed=2.0, delete=False
    )

    # 按键提示
    input("\t[按回车继续]")
    utils.clear_last_lines(1)

    utils.typewriter(
        text="\n\t（点头）好的！我知道了。\n",
        color=Fore.CYAN, speed=0.1, await_speed=2.0, delete=False
    )
    
    # 查看工作手册，打开电脑
    # 按键提示
    input("\t[按回车继续]")
    utils.clear_last_lines(1)
    print()
    

################################################################################
# 打印工作手册
    Workbook_lines = [
        "\t\t╔═══════════════════════════════════════════════════════════════════════╗",
        "\t\t║                    反间谍侦察与特别行动组 工作手册                    ║",
        "\t\t║───────────────────────────────────────────────────────────────────────║",
        "\t\t║                                                                       ║",
        "\t\t║  一、基本信息                                                         ║",
        "\t\t║    工作邮箱号码：agent01@isd.gov                                      ║",
        "\t\t║    工作邮箱密码：TRNDNSA@1960x                                        ║",
        "\t\t║                                                                       ║",
        "\t\t║    工作代号：由组织统一分配，内部使用，不得擅自对外公开。             ║",
        "\t\t║                                                                       ║",
        "\t\t║    特别备注：工作邮箱无法在工作单位以外登录与使用，所有通信内容均由   ║",
        "\t\t║              信息安全部门实时监控，请严守保密条令和单位规章制度。     ║",
        "\t\t║                                                                       ║",
        "\t\t║  二、工作职责                                                         ║",
        "\t\t║     1. 反间谍侦察：识别敌对势力，掌握涉密动态。                       ║",
        "\t\t║     2. 情报收集：获取情报，研判敌情，形成报告。                       ║",
        "\t\t║     3. 网络攻防：防御渗透与攻击，必要时反制。                         ║",
        "\t\t║     4. 执法行动：开展抓捕与排查。                                     ║",
        "\t\t║                                                                       ║",
        "\t\t║   三、工作纪律                                                        ║",
        "\t\t║     · 严格遵守保密制度，不得通过私人渠道传播涉密信息。                ║",
        "\t\t║     · 所有对外言论需符合组织要求。                                    ║",
        "\t\t║     · 行动任务必须听从指挥，不得私自行动。                            ║",
        "\t\t║     · 遇突发情况，第一时间向直属上级汇报。                            ║",
        "\t\t║     · 严格区分生活与工作，杜绝泄密。                                  ║",
        "\t\t║                                                                       ║",
        "\t\t║   四、日常规定                                                        ║",
        "\t\t║     · 上班前检查设备状态。                                            ║",
        "\t\t║     · 每日清理临时文件并提交日志。                                    ║",
        "\t\t║     · 外出任务携带证件、装备。                                        ║",
        "\t\t║     · 禁止擅自拍摄存储机密资料。                                      ║",
        "\t\t║                                                                       ║",
        "\t\t║   五、警示提醒                                                        ║",
        "\t\t║     · 违反保密纪律将依法追责。                                        ║",
        "\t\t║     · 工作邮箱仅限公务用途，不得夹带私事。                            ║",
        "\t\t║     · 所有行动与资料均有留痕，切勿侥幸。                              ║",
        "\t\t║                                                                       ║",
        "\t\t║───────────────────────────────────────────────────────────────────────║",
        "\t\t║                忠诚无瑕、让国安宁、甘于奉献、敢战能胜。               ║",
        "\t\t╚═══════════════════════════════════════════════════════════════════════╝\n",
    ]

    print("\n\n")
    for Workbook_line in Workbook_lines:
        print(f"{Fore.LIGHTGREEN_EX}{Workbook_line}{Style.RESET_ALL}")
        time.sleep(0.12)  # 控制每行之间的延迟

    input("\t[按回车继续]")
    utils.clear_last_lines(1)

    utils.typewriter(
        text="\n\t（打开电脑）\n",
        color=Fore.CYAN, speed=0.1, await_speed=2.0, delete=False
    )

    # 加载动画
    utils.waiting_dots(text="\t...", repeat=3)

    ################################################################################
    # 跳出终端
    title = "AegisNX System"
    # 通过 cmd 调用，title 设置窗口标题
    cmd = f'title {title} && python AegisNX_System.py'

    p = subprocess.Popen(
        ['cmd', '/c', cmd],
        creationflags=subprocess.CREATE_NEW_CONSOLE
    )

    # 不阻塞，继续执行下面的代码
    print(f"{Fore.RED}\t请勿关闭此窗口，系统中负责破案，此窗口负责回答问题。{Style.RESET_ALL}")

    print("\n\n────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────")

    time.sleep(3)
    
################################################################################
# 剧情继续

    utils.typewriter(
        text="\n\t【晴  川】很好，接下来体验一下 AegisNX 模拟系统。\n\t\t  我们先通过练习熟悉一下系统的使用。\n",
        color=Fore.MAGENTA, speed=0.1, await_speed=2.0, delete=False
    )

    input("\t[按回车继续]")
    utils.clear_last_lines(1)
    


    utils.typewriter(
        text="\n\t【晴  川】使用 [CipherMail] 命令打开工作邮箱，了解任务。\n\t\t  核心是：学会收集线索、分析信息、使用工具，并最终锁定目标。\n",
        color=Fore.MAGENTA, speed=0.1, await_speed=2.0, delete=False
    )

    input("\t[按回车继续]")
    utils.clear_last_lines(1)
    


    utils.typewriter(
        text="\n\t【晴  川】下载邮件中的附件，使用 [crypto] 命令打开解密工具，解密文件中的密文。",
        color=Fore.MAGENTA, speed=0.1, await_speed=2.0, delete=False
    )

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t【晴  川】我们接下来应该搜索一下密文中的 ???  \n\t请输入密文中的关键词（注意大小写）：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "ShadowCat":
            utils.typewriter(
                text="\n\t【晴  川】我们接下来应该搜索一下密文中的 ShadowCat \n",
                color=Fore.MAGENTA, speed=0.1, await_speed=4.0, delete=False
            )
            break
        else:
            utils.clear_last_lines(2)
    


    utils.typewriter(
        text="\n\t【晴  川】使用 [sentinelweb] 命令打开浏览器工具，搜索 ShadowCat 看看有何线索？",
        color=Fore.MAGENTA, speed=0.1, await_speed=2.0, delete=False
    )

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t有几个搜索结果？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers in ["3","三"]:
            utils.typewriter(
                text="\n\t【晴  川】将搜索结果一一点开查看。 \n",
                color=Fore.MAGENTA, speed=0.1, await_speed=4.0, delete=False
            )
            break
        else:
            utils.clear_last_lines(2)
    


    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t目标常用昵称是什么？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers in ["shadowcat","ShadowCat"]:
            break
        else:
            utils.clear_last_lines(2)
    
    

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t目标姓名是什么？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "李影":
            break
        else:
            utils.clear_last_lines(2)
    

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t目标邮箱是什么？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "shadowcat@hup.com":
            break
        else:
            utils.clear_last_lines(2)

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t目标电话是什么？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "13800138000":
            break
        else:
            utils.clear_last_lines(2)

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t目标任职公司是什么？  \n\t请输入（XXXXX公司）：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "HUP音乐公司":
            utils.typewriter(
                text="\n\t【晴  川】非常好！现在使用 [DataForge] 命令打开数据库，迅速查询目标信息！ \n",
                color=Fore.MAGENTA, speed=0.1, await_speed=4.0, delete=False
            )
            break
        else:
            utils.clear_last_lines(2)

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t目标身份证号是多少？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "310101199005010001":
            break
        else:
            utils.clear_last_lines(2)

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t目标住址在哪？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "科尔韦工业区柯特路103号":
            utils.typewriter(
                text="\n\t【晴  川】获取到很多信息了！现在使用 [EchoTalk] 命令打开破解软件获取目标常用密码！ \n",
                color=Fore.MAGENTA, speed=0.1, await_speed=4.0, delete=False
            )
            break
        else:
            utils.clear_last_lines(2)

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t目标常用密码是多少？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "Scat900501":
            utils.typewriter(
                text="\n\t【晴  川】OK！密码到手了！现在使用 [SparklyAegis] 命令打开社交软件还有使用邮箱获取目标的其他证据！ \n",
                color=Fore.MAGENTA, speed=0.1, await_speed=4.0, delete=False
            )
            break
        else:
            utils.clear_last_lines(2)

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t资金什么时候转入的？  \n\t请输入（xxxx-xx-xx）：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "2025-08-25":
            break
        else:
            utils.clear_last_lines(2)

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t涉案资金有多少？  \n\t请输入（单位：万）：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers in ["1.6万元","1.6"]:
            utils.typewriter(
                text="\n\t【晴  川】OK！现在使用 [ShadowTrace] 命令打开入侵工具进一步深挖证据！ \n",
                color=Fore.MAGENTA, speed=0.1, await_speed=4.0, delete=False
            )
            break
        else:
            utils.clear_last_lines(2)

    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t可疑联系人手机号？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "13900998877":
            break
        else:
            utils.clear_last_lines(2)


    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t软件加密密码？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "1379":
            break
        else:
            utils.clear_last_lines(2)


    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t行动地点是哪里？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "沃尔斯克东部乔斯伯特区南街":
            utils.typewriter(
                text="\n\t【晴  川】OK！非常棒！接下来使用 [KeyBreaker] 命令打开追踪工具定位嫌疑人位置实施抓捕！ \n",
                color=Fore.MAGENTA, speed=0.1, await_speed=4.0, delete=False
            )
            break
        else:
            utils.clear_last_lines(2)


    while 1:
        sys.stdout.write(Fore.MAGENTA)
        User_answers = input("\n\t嫌疑人定位？  \n\t请输入：")
        sys.stdout.write(Style.RESET_ALL)
        if User_answers == "科尔韦工业区柯特路103号":
            utils.typewriter(
                text="\n\t【晴  川】OK！我去通报抓捕小队实施抓捕！ \n",
                color=Fore.MAGENTA, speed=0.1, await_speed=4.0, delete=False
            )
            break
        else:
            utils.clear_last_lines(2)


    time.sleep(3)
    utils.clear()

    utils.typewriter(
        text="\t恭喜！您已经完成了第一章·新手试炼", 
        color=Fore.WHITE, speed=0.12, await_speed=1.2, delete=True, delete_speed=0.05
    )