# python库导入部分
import sys, time, os, random, logging, subprocess, utils, keyboard, threading, platform, re, getpass, hashlib, yaml, json, glob, shutil
from colorama import init, Fore, Style, Back
from datetime import datetime

#章节程序导入部分
import chapter1_prologue, chapter2_first_trial

############################################################################################################################################
# 初始化部分
init()  # colorama

# 创建日志目录（如果不存在）
log_dir = "./logs"
os.makedirs(log_dir, exist_ok=True)  # exist_ok=True 表示目录已存在也不会报错
formatted = datetime.now().strftime("%Y-%m-%d_%H-%M-%S")

# 配置日志，添加 encoding 参数指定编码为 utf-8
logging.basicConfig(
    level=logging.DEBUG,  # 设置日志级别为 DEBUG，这意味着会记录所有级别（DEBUG、INFO、WARNING、ERROR、CRITICAL）的日志
    format='%(asctime)s - %(levelname)s - %(message)s',  # 定义日志的输出格式
    filename=f'{log_dir}/{formatted}.log',  # 指定日志输出到的文件
    filemode='w',  # 以写入模式打开文件，每次运行程序都会覆盖之前的日志文件
    encoding='utf-8'  # 指定文件编码为 utf-8，确保中文能正常显示
)

# 删除超过五天的日志文件
utils.cleanup_logs()

############################################################################################################################################
# 欢迎使用：游戏 LOGO 介绍 注意事项
sys.stdout.write(Fore.CYAN)
Game_LOGO = r"""
                             111111                                   
                            00000000                                  
                       111000000000000111                             
                  1111000111  1001  1110001111                        
          1100011000011       1001       1100001100011                
         1000000011           1001           1100000001               
          000110001     1111111001111111     100011000              ________        ___    ___   ________    _______     ________           
         100    100011111     1001     111110001    001            |\   ____\      |\  \  /  /| |\   __  \  |\  ___ \   |\   __  \          
        1001      10001       1001       10001      1001           \ \  \___|      \ \  \/  / | \ \  \|\ /_ \ \   __/|  \ \  \|\  \         
       1001       1111001      11      1001111       1001           \ \  \          \ \    / /   \ \   __  \ \ \  \_|/__ \ \   _  _\        
      1001      111    110            011    111      1001           \ \  \____      \/   / /     \ \  \|\  \ \ \  \_|\ \ \ \  \\  \|       
     1001       11                            11       1001           \ \_______\  __/   / /       \ \_______\ \ \_______\ \ \__\\ _\       
 1100001       11             1001             11       1000011        \|_______| |\____/ /         \|_______|  \|_______|  \|__|\|__|      
10000000111111111111111      000000      11111111111111100000001                  \|____|/                                                  
 1100001       11             1001             11       1000011                                                                           
     1001       11                            11       1001         ██████╗ ███████╗███████╗███████╗███╗   ██╗███████╗██╗██╗   ██╗███████╗
      1001      111    110            011    111      1001         ██╔═══██╗██╔════╝██╔════╝██╔════╝████╗  ██║██╔════╝██║██║   ██║██╔════╝
       1001       1111001      11      1001111       1001          ██║   ██║█████╗  █████╗  █████╗  ██╔██╗ ██║███████╗██║██║   ██║█████╗  
        1001      10001       1111       10001      1001           ██║   ██║██╔══╝  ██╔══╝  ██╔══╝  ██║╚██╗██║╚════██║██║╚██╗ ██╔╝██╔══╝ 
         1001   100011111     1111     111110001   1001            ╚██████╔╝██║     ██║     ███████╗██║ ╚████║███████║██║ ╚████╔╝ ███████╗
          000110001     1111111111111111     100011000              ╚═════╝ ╚═╝     ╚═╝     ╚══════╝╚═╝  ╚═══╝╚══════╝╚═╝  ╚═══╝  ╚══════╝
         1000000011           1111           1000000011               
          1100111111111       1111      1111111110011                                                          Cyber-Offensive v0.0.1-beta               
                  111111111   1111   111111111                        
                       111111111111111111                             
                            11111111                                  
                             111111                                   
"""

print(Game_LOGO)
logging.info(f"\n{Game_LOGO}")

time.sleep(1.8)
sys.stdout.write(Fore.LIGHTGREEN_EX)
HuanYing_lines = [
    "\t\t╔════════════════════════════════════════════════════════════════════════════════════════════════╗",
    "\t\t║                       欢迎游玩 网络攻势 Cyber-Offensive@v0.0.1-beta 游戏                       ║",
    "\t\t║────────────────────────────────────────────────────────────────────────────────────────────────║",
    "\t\t║   创作者 ：陆炳阳（Vincent Cassano）                                                           ║",
    "\t\t║  程序描述：这是一款以国家安全为主题的网络安全教育游戏。                                        ║",
    "\t\t║  构建时间：2025 年 8 月 14 日    |    发布时间：2025 年 9 月 30 日（预计）                     ║",
    "\t\t╚════════════════════════════════════════════════════════════════════════════════════════════════╝\n",
    "\t\t📢 本版本更新发布时间：2025 年 9 月 9 日，欢迎提交 issues 与反馈。",
    "\t\t🔗 GitHub: https://github.com/VincentCassano/\n"
]

for HuanYing_line in HuanYing_lines:
    print(HuanYing_line)
    time.sleep(0.26)  # 控制每行之间的延迟

time.sleep(0.8)
sys.stdout.write(Fore.LIGHTRED_EX)
print("\n\t## ========================================= 这是一条分割线 ========================================= ##\n")
sys.stdout.write(Style.RESET_ALL)
time.sleep(1)

############################################################################################################################################
# 获取并确认当前工作路径
current_dir = os.getcwd()
print("────────────────────────────────────────────────────────────────────────")
print(f"📂 当前工作路径：{current_dir}")
print("────────────────────────────────────────────────────────────────────────")
while 1:
    queren_current_dir = input("\n请确认工作路径(Y/n)：").upper()
    if queren_current_dir == "Y":
        logging.info(f"工作路径：{current_dir}")
        break
    elif queren_current_dir == "N":
        print(f"{Fore.YELLOW}[警告] 正在退出程序！请更换工作路径再运行此程序！{Style.RESET_ALL}")
        time.sleep(2)
        sys.exit(0)
    else:
        print(f"{Fore.RED}请输入[Y/n] ! ! ! {Style.RESET_ALL}")
        time.sleep(1)
        utils.clear_last_lines(2)

############################################################################################################################################
# 程序主要部分

################################################################################
# 用户隐私协议、使用条款与须知

# 终端窗口标题
title = "免责声明"  
# 通过 cmd 调用，title 设置窗口标题
cmd = f'title {title} && python User_Privacy_Agreement_Terms_of_Use_and_Notices.py'

p = subprocess.Popen(
    ['cmd', '/c', cmd],
    creationflags=subprocess.CREATE_NEW_CONSOLE
)
print(f"{Fore.RED}请阅读完并同意《用户隐私协议、使用条款与须知》才可继续游玩，若是强制关闭默认为同意《用户隐私协议、使用条款与须知》{Style.RESET_ALL}")
p.wait()
time.sleep(0.6)
utils.clear_last_lines(21)
print("\n\n────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────")



################################################################################
# 游戏菜单：新游戏、继续游戏、存档管理、加载存档、制作人员、关于游戏

while True:
    while True:
        
        # new_or_continue = "继续游戏" if has_save else " 新游戏 "
        new_or_continue = " 新游戏 "
        Game_Main_Menus = [
            "\n\t╔═════════════╗",
            "\t║  游戏主菜单 ║",
            "\t╠═════════════╣",
            f"\t║ A. {new_or_continue} ║",
            "\t║ B. 存档管理 ║",
            "\t║ C. 加载存档 ║",
            "\t║ D. 制作人员 ║",
            "\t║ E. 关于游戏 ║",
            "\t║ Q. 退出游戏 ║",
            "\t╚═════════════╝\n"
        ]

        for Game_Main_Menu in Game_Main_Menus:
            print(Game_Main_Menu)
            time.sleep(0.03)  # 控制每行之间的延迟

        User_Main_menu_options = input("请选择（A/B/C/D/E/Q）：").strip().upper()
        if User_Main_menu_options in ["A","B","C","D","E","Q"]:
            utils.clear_last_lines(12)
            break
        elif User_Main_menu_options == "Vincent Cassano":
            print("╔══════════════════╗")
            print(f"║ {Fore.CYAN}祝你开心一整天！{Style.RESET_ALL} ║")
            print("╚══════════════════╝")
            time.sleep(1)
            utils.clear_last_lines(15)
        else:
            print("╔══════════════════╗")
            print(f"║ {Fore.RED}没有此选项！！！{Style.RESET_ALL} ║")
            print("╚══════════════════╝")
            time.sleep(1)
            utils.clear_last_lines(15)

    ################################################################################
    # 用户主菜单选项判断
    if User_Main_menu_options == "A":
        # 新游戏 或 继续游戏
        chapter1_prologue.Chapter1_Prologue_game()


    elif User_Main_menu_options == "B":
        # 存档管理
        print("╔════════════════╗")
        print(f"║ {Fore.RED}此功能待完善！{Style.RESET_ALL} ║")
        print("╚════════════════╝")
        time.sleep(1)
        utils.clear_last_lines(3)
        print()

    elif User_Main_menu_options == "C":
        # 加载存档
        print("╔════════════════╗")
        print(f"║ {Fore.RED}此功能待完善！{Style.RESET_ALL} ║")
        print("╚════════════════╝")
        time.sleep(1)
        utils.clear_last_lines(3)
        print()

    elif User_Main_menu_options == "D":
        # 制作人员
        credits = [
            "╔═══════════════════════════════════════╗",
            "║             🎬 制作人员表             ║",
            "╠═══════════════════════════════════════╣",
            "║  游戏主办：Vincent Cassano            ║",
            "║  游戏设计：Vincent Cassano            ║",
            "║  游戏策划：Vincent Cassano            ║",
            "║  程序开发：Vincent Cassano、ChatGPT   ║",
            "║  剧情编写：Vincent Cassano、ChatGPT   ║",
            "║  美术设计：Vincent Cassano、ChatGPT   ║",
            "║  测试人员：Vincent Cassano            ║",
            "╚═══════════════════════════════════════╝",
        ]

        for credit in credits:
            print(credit)
            time.sleep(0.08)  # 控制每行之间的延迟
        time.sleep(2)
        utils.clear_last_lines(11)
        print()

    elif User_Main_menu_options == "E":
        # 关于游戏
        abouts = [
            "╔═══════════════════════════════════════╗",
            "║              📖 关于游戏              ║",
            "╠═══════════════════════════════════════╣",
            "║  游戏名 ：Cyber-Offensive             ║",
            "║  版本号 ：v0.0.1-beta                 ║",
            "║  基  于 ：Python3.13                  ║",
            "║  作  者 ：Vincent Cassano             ║",
            "║ 联系方式：w15316153525wct@outlook.com ║",
            "║ 版权声明：本游戏仅用于学习与交流      ║",
            "╚═══════════════════════════════════════╝",
        ]
        for about in abouts:
            print(about)
            time.sleep(0.08)  # 控制每行之间的延迟
        time.sleep(3)
        utils.clear_last_lines(10)
        print()

    elif User_Main_menu_options == "Q":
        # 退出游戏
        sys.exit(0)



################################################################################