"""
#### 函数文件
"""
############################################################################################################################################
# python库导入部分
import sys, time, os, random, logging, subprocess, utils, keyboard, threading, platform, re, getpass, hashlib, yaml, socket, psutil, json
from colorama import init, Fore, Style, Back
from datetime import datetime
from rich.progress import track  # 可以使用 rich 库实现酷炫进度条
from ruamel.yaml import YAML
from ruamel.yaml.comments import CommentedSeq

############################################################################################################################################
# 模拟打字效果
def typewriter(text, color=Fore.WHITE, speed=0.05, await_speed=1.0, delete=False, delete_speed=0.05):
    """
    模拟打字机效果，支持打印和逐字删除

    参数:
        text (str): 要输出的文本
        color (colorama.Fore): 输出颜色
        speed (float): 打字速度（秒/字符）
        await_speed (float): 等待时间（秒）
        delete (bool): 是否在打印后逐字删除
        delete_speed (float): 删除速度（秒/字符）
    """
    #paused_event.set() # 游戏暂停的代码
    # 打印文字
    for char in text:
        #paused_event.wait() # 游戏暂停的代码
        sys.stdout.write(color + char + Style.RESET_ALL)
        sys.stdout.flush()
        time.sleep(speed)

    time.sleep(await_speed)
    # 如果需要删除
    if delete:
        # 按行处理
        lines = text.split('\n')
        line_lengths = [len(line) for line in lines]  # 每行的长度

        # 从最后一行开始逐行删除
        for i in range(len(lines)-1, -1, -1):
            line = lines[i]
            for _ in range(len(line)*2+10):
                sys.stdout.write('\b \b')  # 删除当前行的每个字符
                sys.stdout.flush()
                time.sleep(delete_speed)
            if i != 0:  # 如果不是第一行
                sys.stdout.write('\033[F')                 # 光标上移一行
                sys.stdout.write('\033[{}C'.format(line_lengths[i-1]*2+10))  # 移动到上一行末尾
                sys.stdout.flush()

# 示例
# typewriter("Hello, Vincent!", color=Fore.GREEN, speed=0.1, delete=True, delete_speed=0.05)

############################################################################################################################################
# 清除部分输出（行）
def clear_last_lines(n=1):
    """
    清除部分输出（行）

    参数:
        n (int): 清除的行数
    """
    for _ in range(n):
        sys.stdout.write("\033[F")  # 光标上移一行
        sys.stdout.write("\033[K")  # 清除该行
    sys.stdout.write("\033[F")  # 再额外上移一行，回到正确位置

# 示例
# clear_last_lines(n=20)

############################################################################################################################################
# 清理多余日志
def cleanup_logs(log_dir="./logs", keep_days=3):
    """
    清理多余日志

    参数:
        log_dir (str): log文件路径
        keep_days (int): 几天前的删除
    """
    # 获取目录下所有日志文件
    files = [f for f in os.listdir(log_dir) if f.endswith(".log")]
    if not files:
        return

    # 将文件按时间戳解析为 datetime
    file_infos = []
    for f in files:
        try:
            # 文件名格式：2025-08-15_19-04-16.log
            ts_str = f[:-4]  # 去掉 .log
            ts = datetime.strptime(ts_str, "%Y-%m-%d_%H-%M-%S")
            file_infos.append((f, ts))
        except:
            continue  # 忽略无法解析的文件

    # 按时间降序排序
    file_infos.sort(key=lambda x: x[1], reverse=True)

    # 保留的文件列表
    keep_files = []

    # 当天日期
    today = datetime.now().date()
    # 记录已保留的日期集合
    dates_kept = set()

    for fname, ts in file_infos:
        file_date = ts.date()
        if file_date == today:
            keep_files.append(fname)  # 当天日志全部保留
        elif len(dates_kept) < (keep_days - 1):  # 剩余 N-1 个日期可以保留
            keep_files.append(fname)
            dates_kept.add(file_date)
        # 超出范围的文件不加入 keep_files

    # 删除不在 keep_files 的旧文件
    for f, _ in file_infos:
        if f not in keep_files:
            try:
                os.remove(os.path.join(log_dir, f))
                logging.warning(f"[系统] 已删除旧日志: {f}")
            except Exception as e:
                print(f"{Fore.RED} [系统] 删除日志失败: {f}，原因: {e} {Style.RESET_ALL}")
                
                logging.warning(f"[系统] 删除日志失败: {f}，原因: {e}")

# 示例
# cleanup_logs()

############################################################################################################################################
# 等待省略号动画
def waiting_dots(text="加载中", dot_count=3, interval=0.5, repeat=1):
    """
    打印带省略号的等待动画
    """
    for _ in range(repeat):
        for i in range(dot_count + 1):
            sys.stdout.write("\r" + text + "." * i + " " * (dot_count - i))
            sys.stdout.flush()
            time.sleep(interval)
    # 不要再多输出一次了
    sys.stdout.write("\n")  # 只是换行，避免和下一个输出粘在一起


# 示例
# waiting_dots(text="...", repeat=3)

############################################################################################################################################
# 定义退出函数
"""
# def exit_program():
#     print("\n\n[系统提示] 检测到 ESC 按键，正在退出程序...")
#     os._exit(0)

# # 在后台线程监听 Esc
# def hotkey_listener():
#     keyboard.add_hotkey("esc", exit_program)
#     keyboard.wait()  # 一直等待按键，不会阻塞主程序
"""

# # 示例
# # 启动监听线程（守护线程，程序退出时自动结束）
# # thread = threading.Thread(target=hotkey_listener, daemon=True)
# # thread.start()

############################################################################################################################################
# 定义游戏暂停函数
"""
# running = True   # 游戏是否运行
# paused = False   # 是否暂停（菜单状态）
# paused_event = threading.Event()  # 用于阻塞主线程

# def esc_listener():
#     global paused
#     while running:
#         keyboard.wait("esc")
#         paused = not paused  # 切换暂停状态
#         if paused:
#             paused_event.clear()  # 暂停
#             sys.stdout.write("[已暂停]")
#             sys.stdout.flush()
#         else:
#             paused_event.set()  # 继续
#             sys.stdout.write("\b" * 8 + " " * 8 + "\b" * 8)  # 5 是 "[已暂停]" 的长度
#             sys.stdout.flush()
"""

# # 示例
# # 开启 ESC 监听线程
# # listener_thread = threading.Thread(target=esc_listener, daemon=True)
# # listener_thread.start()

############################################################################################################################################
# 获取用户桌面文件夹路径
def get_desktop_path():
    home = os.path.expanduser("~")
    system = platform.system()
    if system == "Windows":
        return os.path.join(home, "Desktop")
    elif system == "Darwin":  # macOS
        return os.path.join(home, "Desktop")
    else:  # Linux
        return os.path.join(home, "桌面")  # 中文桌面名在部分 Linux 发行版
    
# 示例 
# get_desktop_path()

############################################################################################################################################
# 获取硬件信息
class SystemInfoCollector:
    """系统硬件与软件信息收集类"""

    def __init__(self):
        self.info = {}

    def run_cmd(self, cmd):
        """运行系统命令并返回结果"""
        try:
            output = subprocess.check_output(cmd, shell=True, stderr=subprocess.DEVNULL)
            return output.decode(errors="ignore").strip()
        except:
            return "未知"

    def clean_lines(self, raw):
        """去掉表头和空行"""
        lines = [line.strip() for line in raw.splitlines() if line.strip()]
        if len(lines) >= 2:
            return lines[1:]  # 去掉表头
        return lines

    def collect(self):
        """收集系统信息"""
        info = {}

        # 系统信息
        info['系统'] = platform.system()
        info['系统版本'] = platform.version()
        info['Python版本'] = platform.python_version()

        # Windows 特有：获取详细系统名称
        if info['系统'] == "Windows":
            caption_raw = self.run_cmd("wmic os get Caption")
            caption_list = self.clean_lines(caption_raw)
            info['系统名称'] = caption_list[0] if caption_list else info['系统']
            info['系统名称'] = caption_list[0][:-3]
        else:
            info['系统名称'] = info['系统']


        # CPU
        cpu_raw = self.run_cmd("wmic cpu get Name")
        cpu_list = self.clean_lines(cpu_raw)
        info['CPU型号'] = cpu_list[0] if cpu_list else "未知"

        # 内存
        mem_raw = self.run_cmd("wmic memorychip get Manufacturer, PartNumber, Capacity, Speed")
        mem_list = self.clean_lines(mem_raw)
        total_mem_raw = self.run_cmd("wmic ComputerSystem get TotalPhysicalMemory")
        total_mem_lines = self.clean_lines(total_mem_raw)
        if total_mem_lines:
            try:
                total_mem_gb = int(total_mem_lines[0]) / (1024**3)
                info['内存总量(GB)'] = f"{total_mem_gb:.2f} GB"
            except:
                info['内存总量(GB)'] = "未知"
        else:
            info['内存总量(GB)'] = "未知"

        info['内存详情'] = mem_list if mem_list else ["未知"]

        # GPU
        gpu_name_raw = self.run_cmd("wmic path win32_videocontroller get name")
        gpu_list = self.clean_lines(gpu_name_raw)
        info['GPU型号'] = gpu_list[-1] if gpu_list else "未知"

        gpu_ram_raw = self.run_cmd("wmic path win32_videocontroller get AdapterRAM")
        gpu_ram_gb = "未知"
        for line in gpu_ram_raw.splitlines():
            line = line.strip()
            if line and line != "AdapterRAM":
                try:
                    ram_bytes = int(line)
                    gpu_ram_gb = f"{(ram_bytes / (1024**3)*3):.0f} GB"
                    break
                except:
                    continue
        info['GPU显存'] = gpu_ram_gb

        # 主板
        board_raw = self.run_cmd("wmic baseboard get Manufacturer, Product, SerialNumber")
        board_list = self.clean_lines(board_raw)
        info['主板型号'] = board_list[-1] if board_list else "未知"

        self.info = info
        return info

    def display(self):
        """打印系统信息"""
        if not self.info:
            self.collect()

        print(f"系 统 名 称 : {self.info['系统名称']}")
        print(f"系 统 版 本 : {self.info['系统版本']}")
        print(f"Python 版 本: {self.info['Python版本']}")
        print(f"C P U 型 号 : {self.info['CPU型号']}")

        print("内 存 信 息 :")
        for mem in self.info['内存详情']:
            print(f"\t      {mem}")
        print(f"内 存 总 量 : {self.info['内存总量(GB)']}")

        print(f"G P U 型 号 : {self.info['GPU型号']}")
        print(f"G P U 显 存 : {self.info['GPU显存']}")
        print(f"主 板 型 号 : {self.info['主板型号']}")


# 示例
# if __name__ == "__main__":
#     collector = SystemInfoCollector()
#     collector.collect()
#     collector.display()

############################################################################################################################################
# 清理所有输出
def clear():
    """
    清理所有输出
    """
    os.system('cls' if os.name == 'nt' else 'clear')

# 示例
# clear()


############################################################################################################################################
# 密码强度验证
def passwd_clear():
    time.sleep(1)
    utils.clear_last_lines(1)
    print("                                                  \n")
    utils.clear_last_lines(1)


def check_password_strength(pwd: str,weak_passwords: set) -> bool:
    """密码强度检查"""
    # 长度验证
    if len(pwd) <= 8:
        print("❌ 密码长度必须大于 8 位")
        passwd_clear()
        return False

    # 正则验证规则
    if not re.search(r"[0-9]", pwd):
        print("❌ 密码必须包含数字")
        passwd_clear()
        return False
    if not re.search(r"[A-Z]", pwd):
        print("❌ 密码必须包含大写字母")
        passwd_clear()
        return False
    if not re.search(r"[a-z]", pwd):
        print("❌ 密码必须包含小写字母")
        passwd_clear()
        return False
    if not re.search(r"[@#&.]", pwd):
        print("❌ 密码必须包含特殊符号（@ # & .）")
        passwd_clear()
        return False

    # 弱密码字典验证（忽略大小写）
    if pwd.lower() in weak_passwords:
        print("❌ 密码过于简单，请更换")
        passwd_clear()
        return False

    return True



############################################################################################################################################
# 系统用户管理
class UserManager:
    """
    用户管理类，用于处理 AegisNX OS 的用户注册和登录功能。
    
    功能：
    - 注册新用户，并保存用户名和密码（SHA-256 哈希）到文件。
    - 检查系统中是否已有注册用户。
    - 验证用户登录信息是否正确。
    - 登录已注册用户。
    
    属性：
    - user_file (str): 存储用户信息的文件路径，默认 "users.txt"。
    """

    def __init__(self, user_file="users.txt"):
        """初始化 UserManager 实例"""
        self.user_file = user_file

    def hash_password(self, password):
        """返回密码的 SHA-256 哈希"""
        return hashlib.sha256(password.encode("utf-8")).hexdigest()

    def has_registered_users(self):
        """检查 users.txt 是否存在注册用户"""
        if not os.path.exists(self.user_file):
            return False
        try:
            with open(self.user_file, "r", encoding="utf-8") as f:
                for line in f:
                    if line.strip():  # 非空行
                        return True
            return False
        except Exception:
            return False

    def is_valid_login(self, username, password):
        """验证用户名和密码"""
        if not os.path.exists(self.user_file):
            return False
        hashed_input = self.hash_password(password)
        try:
            with open(self.user_file, "r", encoding="utf-8") as f:
                for line in f:
                    saved_user, saved_pass = line.strip().split(":")
                    if saved_user == username and saved_pass == hashed_input:
                        return True
            return False
        except Exception:
            return False

    def register_user(self, weak_passwords):
        """
        注册新用户，并将用户名和密码（哈希）保存到 users.txt。
        如果密码强度不够，将提示用户重新输入。
        """
        print("=== AegisNX OS 用户注册 ===")
        username = input("用户昵称：")

        while True:
            userpass = input("用户密码：")
            if utils.check_password_strength(userpass, weak_passwords):
                break
            else:
                print("密码强度不够，请重新输入。")

        # 保存到 users.txt 文件
        with open(self.user_file, "a", encoding="utf-8") as f:
            f.write(f"{username}:{self.hash_password(userpass)}\n")

        print(f"\n✅ 注册成功！欢迎你，{username}")
        time.sleep(1)
        utils.clear()

        return username

    def login_user(self):
        """登录已注册用户"""
        while True:
            print("=== AegisNX OS 用户登录 ===")
            username = input("用户名：")
            password = input("密码：")
            if self.is_valid_login(username, password):
                print(f"\n✅ 登录成功！欢迎回来，{username}")
                break
            else:
                print("\n❌ 用户名或密码错误，请重试。")
                time.sleep(1)
                utils.clear()
        time.sleep(1)
        utils.clear()

        return username



############################################################################################################################################
# 添加新邮件

yaml = YAML()
yaml.indent(mapping=2, sequence=4, offset=2)  # 美化缩进

def add_mail(to_user, title, sender, content, attachment=None):
    """
    往 mails.yaml 添加新邮件，并保留原注释和字段顺序。

    参数:
    - to_user: 收件人用户名 (str)
    - title: 邮件标题 (str)
    - sender: 发件人 (str)
    - content: 邮件正文 (str)
    - attachment: 附件字典, 例如 {"filename": "report.txt", "content": "附件内容"}，可选
    """

    # 读取已有邮件
    if os.path.exists("./YAML_Data_storage_files/mails.yaml"):
        with open("./YAML_Data_storage_files/mails.yaml", "r", encoding="utf-8") as f:
            data = yaml.load(f)
            if data is None:
                data = []
    else:
        data = []

    # 全局 id
    new_id = max([m["id"] for m in data], default=0) + 1

    # 用户局部编号 uid
    user_mails = [m for m in data if m.get("to") == to_user]
    new_uid = max([m["uid"] for m in user_mails], default=0) + 1

    # 构造新邮件字典
    mail_dict = {
        "id": new_id,
        "uid": new_uid,
        "title": title,
        "from": sender,
        "to": to_user,
        "date": datetime.now().strftime("%Y-%m-%d %H:%M:%S"),
        "content": content
    }

    if attachment:
        mail_dict["attachment"] = attachment

    # 追加邮件
    data.append(mail_dict)

    # 给新元素前插入一个空行
    data.yaml_set_comment_before_after_key(len(data) - 1, before="\n")

    # 写回 YAML 文件
    with open("./YAML_Data_storage_files/mails.yaml", "w", encoding="utf-8") as f:
        yaml.dump(data, f)

    print(f"✅ 邮件已发送给 {to_user}，标题：{title}")

# 示例
# add_mail(
#     to_user="agent01@isd.gov",
#     title="周报提醒",
#     sender="manager@company.com",
#     content="请在周五前提交本周周报。",
#     attachment={"filename": "weekly_report.txt", "content": "这里是附件内容"}
# )


############################################################################################################################################
# 数据库电话\生日\住址分类
def identify_field(query: str):
    """识别字段类型：phone / birthday / address"""
    if re.match(r"^\d{11}$", query):  # 电话
        return "phone"
    elif re.match(r"^\d{4}-\d{2}-\d{2}$", query):  # 生日
        return "birthday"
    elif any(ch in query for ch in ["省", "市", "区", "路", "街", "镇", "村", "号"]):
        return "address"
    else:
        return "[Error] 无法识别"
    

